# Installation Guide

## Quick Start

Follow these simple steps to install and configure the Internal Link Suggester plugin:

## Step 1: Upload Plugin

**Option A: Via WordPress Admin**
1. Go to your WordPress admin panel
2. Navigate to **Plugins > Add New**
3. Click **Upload Plugin**
4. Choose the `internal-link-suggester.zip` file
5. Click **Install Now**
6. Click **Activate Plugin**

**Option B: Via FTP/File Manager**
1. Extract the `internal-link-suggester` folder from the zip file
2. Upload the entire folder to `/wp-content/plugins/`
3. Go to **Plugins** in WordPress admin
4. Find **Internal Link Suggester** and click **Activate**

## Step 2: Initial Configuration

### Configure Your Sitemap

1. In WordPress admin, go to **Link Suggester > Settings**
2. Enter your sitemap URL
   - Most WordPress sites have a sitemap at: `https://yoursite.com/sitemap.xml`
   - If you use Yoast SEO: `https://yoursite.com/sitemap_index.xml`
   - If you use Rank Math: `https://yoursite.com/sitemap_index.xml`
   - If you use All in One SEO: `https://yoursite.com/sitemap.xml`
3. Set maximum suggestions (recommended: 5)
4. Enable auto-refresh if desired
5. Click **Save Settings**

### Import Your Links

1. Go to **Link Suggester** (main dashboard)
2. Click **Refresh Sitemap**
3. Wait for the process to complete
4. You should see a success message with the number of links imported

## Step 3: Add Keywords

1. Navigate to **Link Suggester > Manage Keywords**
2. You'll see a list of all URLs from your sitemap
3. For each URL, add relevant keywords in the text field
   - Separate keywords with commas
   - Example: `WordPress, blogging, content management`
4. Click **Save** after adding keywords to each URL
5. Or add keywords to multiple URLs and click **Save All Changes**

## Step 4: Start Using

### In Gutenberg Editor:
1. Open or create a post
2. Click the three dots (⋮) in the top toolbar
3. Select **Link Suggestions** from the dropdown
4. The suggestions panel will appear on the right
5. Click **Copy Link** on any suggestion
6. Paste it into your content

### In Classic Editor:
1. Open or create a post
2. Look for the **Internal Link Suggestions** box in the sidebar
3. Click **Insert Link** on any suggestion
4. Paste it into your content

## Verification Checklist

After installation, verify everything is working:

- [ ] Plugin is activated
- [ ] Settings page is accessible
- [ ] Sitemap URL is configured
- [ ] Sitemap has been refreshed successfully
- [ ] Links appear in Manage Keywords page
- [ ] Keywords have been added to at least a few URLs
- [ ] Suggestions appear when editing a post
- [ ] Copy/Insert link functionality works

## Common Installation Issues

### Issue: Can't find the plugin menu

**Solution:** Make sure you have administrator privileges. The plugin requires the `manage_options` capability.

### Issue: Sitemap refresh fails

**Solutions:**
- Verify the sitemap URL is correct by opening it in a browser
- Check if your server allows outbound HTTP connections
- Make sure the sitemap is not password-protected
- Try using the full URL with `https://` or `http://`

### Issue: Database table not created

**Solution:**
- Deactivate and reactivate the plugin
- Check your database user has CREATE TABLE permissions
- Look for PHP errors in WordPress debug log

### Issue: No links appearing in Manage Keywords

**Solution:**
- Ensure sitemap refresh completed successfully
- Verify your sitemap contains valid URLs
- Check that your sitemap follows standard XML format

## File Structure

After installation, your plugin directory should look like this:

```
/wp-content/plugins/internal-link-suggester/
├── internal-link-suggester.php (main plugin file)
├── README.md
├── INSTALLATION.md
├── includes/
│   ├── class-sitemap-parser.php
│   ├── class-keyword-matcher.php
│   └── class-link-suggester.php
├── admin/
│   └── class-admin-interface.php
└── assets/
    ├── css/
    │   └── admin-style.css
    └── js/
        ├── admin-script.js
        └── editor-script.js
```

## System Requirements

Before installing, ensure your server meets these requirements:

- WordPress 5.0 or higher
- PHP 7.0 or higher
- MySQL 5.6 or higher
- `allow_url_fopen` enabled in PHP (for fetching external sitemaps)

## Next Steps

After successful installation:

1. Add keywords to all your important pages first
2. Test the suggestions on a draft post
3. Train your content team on how to use the plugin
4. Set up a schedule to review and update keywords monthly
5. Monitor which suggested links are most commonly used

## Need Help?

If you encounter any issues during installation:

1. Check the WordPress debug log for errors
2. Review the Troubleshooting section in README.md
3. Ensure all system requirements are met
4. Try deactivating other plugins to check for conflicts

## Security Note

The plugin follows WordPress security best practices:
- All inputs are sanitized
- All outputs are escaped
- Nonces are used for AJAX requests
- Database queries use prepared statements
- Only administrators can access plugin settings
