# Quick Start Guide

Get up and running with Internal Link Suggester in 5 minutes!

## Installation (2 minutes)

1. Upload the `internal-link-suggester` folder to `/wp-content/plugins/`
2. Activate the plugin in WordPress admin under **Plugins**
3. Look for the new **Link Suggester** menu item

## Setup (3 minutes)

### Step 1: Configure Sitemap (30 seconds)
- Go to **Link Suggester > Settings**
- Enter your sitemap URL (usually `https://yoursite.com/sitemap.xml`)
- Click **Save Settings**

### Step 2: Import Links (1 minute)
- Go to **Link Suggester** dashboard
- Click **Refresh Sitemap**
- Wait for success message

### Step 3: Add Keywords (2 minutes)
- Go to **Link Suggester > Manage Keywords**
- Add keywords to your top 5-10 pages
- Format: `keyword1, keyword2, keyword3`
- Click **Save All Changes**

## Usage (30 seconds per post)

**When writing a post:**

1. Open the **Link Suggestions** panel (click ⋮ menu → Link Suggestions)
2. See relevant internal links based on your content
3. Click **Copy Link** on any suggestion
4. Paste into your content
5. Done!

## Example Keywords

```
Homepage:
home, main page, website, homepage

About Page:
about us, company, team, who we are

Blog Post about SEO:
SEO, search optimization, ranking, Google, search engine

Product Page:
buy, purchase, product, shop, pricing
```

## Tips for Best Results

1. **Start Small**: Add keywords to your 10 most important pages first
2. **Be Specific**: Use exact phrases people use in content
3. **Use Variations**: Include synonyms and related terms
4. **Keep Updated**: Review and update keywords monthly
5. **Natural Writing**: Write normally, don't force keywords

## Common Mistakes to Avoid

- Adding too few keywords (minimum 3-5 per page)
- Using only single words (use phrases too)
- Forgetting to save after adding keywords
- Not refreshing sitemap after adding new pages
- Ignoring suggestions (they're smart!)

## Keyboard Shortcuts

- **Copy Link**: Click the button or manually copy from suggestion
- **Refresh Suggestions**: Click refresh button in suggestions panel

## What to Do Next

1. ✅ Install and activate
2. ✅ Configure sitemap
3. ✅ Refresh sitemap
4. ✅ Add keywords to top pages
5. ✅ Create a test post
6. ✅ Check suggestions
7. ✅ Insert some links
8. ✅ Train your team
9. ✅ Add keywords to remaining pages
10. ✅ Monitor and optimize

## Support

If something doesn't work:
1. Check that sitemap URL is correct
2. Verify keywords are saved
3. Make sure content contains matching keywords
4. See troubleshooting in README.md

## That's It!

You're ready to start improving your internal linking structure and SEO. Happy linking! 🔗
