# SEOINUX SEO Internal Link Creator

A powerful WordPress plugin that automatically suggests relevant internal links from your sitemap.xml with **auto-generated keywords** from page titles. Powered by **Supabase** for scalable, cloud-based keyword management.

## 🚀 Key Features

- **Auto-Generated Keywords**: Automatically extracts keywords from post/page titles
- **Supabase Integration**: Cloud-based storage for unlimited scalability
- **Smart Keyword Matching**: Intelligent algorithm finds contextually relevant links
- **Gutenberg & Classic Editor**: Works with both WordPress editors
- **Real-time Suggestions**: Get link suggestions as you write
- **Editable Keywords**: Review and customize auto-generated keywords
- **SEO Optimized**: Improve internal linking structure for better search rankings

## 🆕 What's New in Version 2.0

- ✨ **Automatic Keyword Generation** from post/page titles
- ☁️ **Supabase Database** replaces local WordPress database
- 🎯 **Combined Keyword System** (auto-generated + custom keywords)
- 🔄 **Regenerate Keywords** button for individual URLs
- 💾 **Cloud Storage** for better performance and scalability
- 🎨 **Updated UI** with new branding and features

## Installation

1. Upload the `seoinux-seo-internal-link` folder to `/wp-content/plugins/`
2. Activate the plugin through WordPress admin
3. Go to **Link Creator > Settings** and configure your sitemap URL
4. Click **Refresh Sitemap** to import links and generate keywords
5. Review and customize keywords in **Manage Keywords**
6. Start writing and get intelligent link suggestions!

## Configuration

### Supabase Setup

The plugin uses Supabase for storing keywords. Configuration options:

**Option 1: Use wp-config.php (Recommended)**
```php
define('SEOINUX_SUPABASE_URL', 'your-supabase-url');
define('SEOINUX_SUPABASE_KEY', 'your-anon-key');
```

**Option 2: Use Environment Variables**
```bash
VITE_SUPABASE_URL=your-supabase-url
VITE_SUPABASE_ANON_KEY=your-anon-key
```

The plugin will automatically detect and use these credentials.

### Initial Setup

1. **Configure Sitemap** (Link Creator > Settings)
   - Enter your sitemap.xml URL
   - Enable auto-generate keywords (recommended)
   - Set maximum suggestions per post
   - Enable daily auto-refresh if desired

2. **Import Links** (Link Creator Dashboard)
   - Click "Refresh Sitemap & Auto-Generate Keywords"
   - Wait for the import to complete
   - View statistics on the dashboard

3. **Manage Keywords** (Link Creator > Manage Keywords)
   - Review auto-generated keywords
   - Add custom keywords if needed
   - Use "Regenerate" to refresh auto-keywords
   - Save changes

## How It Works

### Automatic Keyword Generation

When you refresh the sitemap, SEOINUX:
1. Fetches all URLs from sitemap.xml
2. Extracts the page/post title
3. Automatically generates relevant keywords:
   - Full title as primary keyword
   - Individual important words
   - 2-word and 3-word phrases
   - Removes stop words (the, a, is, etc.)
4. Stores keywords in Supabase cloud database

### Link Suggestion Algorithm

When writing content:
1. Analyzes your post content
2. Matches content against both auto-generated and custom keywords
3. Calculates relevance scores based on keyword frequency
4. Ranks suggestions by relevance
5. Excludes current page and existing links
6. Returns top N suggestions (configurable)

## Usage

### Gutenberg Editor

1. Create or edit a post
2. Click the three dots (⋮) menu → **SEOINUX Link Suggestions**
3. View auto-updated suggestions in the sidebar
4. Click **Copy Link** to copy the HTML link
5. Paste into your content
6. Click **Refresh Suggestions** for manual updates

### Classic Editor

1. Create or edit a post
2. Find **SEOINUX Link Suggestions** meta box in sidebar
3. Click **Insert Link** to copy link HTML
4. Paste into your content editor

## Keyword Management

### Auto-Generated Keywords

Example for page titled "WordPress SEO Tips for Beginners":

Auto-generated keywords:
```
WordPress SEO Tips for Beginners, WordPress SEO Tips, SEO Tips Beginners,
wordpress, seo, tips, beginners
```

### Custom Keywords

Add your own keywords to supplement auto-generated ones:
```
Custom: SEO optimization, search ranking, WordPress guide
Combined: All auto + custom keywords used for matching
```

### Regenerate Keywords

Click "Regenerate" button to:
- Refresh auto-keywords based on current title
- Useful after editing post titles
- Preserves your custom keywords

## Best Practices

### For Best Results

1. **Let Auto-Generation Work**: The algorithm generates comprehensive keywords
2. **Add Strategic Custom Keywords**: Supplement with synonyms and variations
3. **Review Top Pages First**: Focus on your most important content
4. **Keep Keywords Relevant**: Remove irrelevant auto-generated terms
5. **Update Regularly**: Regenerate after major title changes

### Keyword Examples

**Blog Post: "10 Best WordPress Plugins for 2024"**
- Auto: 10 Best WordPress Plugins, Best WordPress Plugins, wordpress, plugins
- Custom: plugin recommendations, must-have plugins, essential plugins

**Service Page: "Professional Web Design Services"**
- Auto: Professional Web Design Services, Web Design Services, professional, design
- Custom: website design, web development, design agency

**Product Page: "Premium WordPress Theme - Corporate"**
- Auto: Premium WordPress Theme Corporate, WordPress Theme, premium, theme
- Custom: business theme, company website, professional theme

## Database Schema

Supabase table: `seoinux_links`

```sql
- id: UUID (primary key)
- url: TEXT (unique)
- title: TEXT
- auto_keywords: TEXT (auto-generated)
- keywords: TEXT (custom, editable)
- created_at: TIMESTAMP
- updated_at: TIMESTAMP
```

## Technical Details

### Performance

- Cloud-based storage eliminates local database overhead
- Efficient keyword matching algorithm
- Cached results for faster suggestions
- No impact on front-end performance
- Optimized AJAX requests

### Security

- Row Level Security (RLS) enabled on Supabase
- Public read access for suggestions
- Authenticated write for keyword management
- Nonce verification for all AJAX requests
- Input sanitization throughout

### Scalability

- Supabase handles unlimited links
- Scales with your site growth
- No local database limitations
- Cloud backups included
- Multi-site compatible

## Troubleshooting

### No Suggestions Appearing

1. Verify Supabase credentials are configured
2. Check sitemap URL in settings
3. Ensure sitemap refresh completed successfully
4. Confirm keywords exist (auto or custom)
5. Write content with matching keywords

### Auto-Keywords Not Generated

1. Enable "Auto-Generate Keywords" in settings
2. Click "Refresh Sitemap" button
3. Use "Regenerate" button for individual URLs
4. Check page titles are descriptive

### Supabase Connection Issues

1. Verify SEOINUX_SUPABASE_URL is correct
2. Check SEOINUX_SUPABASE_KEY is valid
3. Ensure Supabase project is active
4. Check WordPress debug log for errors

### Keywords Not Saving

1. Verify Supabase RLS policies are configured
2. Check user has admin capabilities
3. Clear browser cache
4. Check browser console for errors

## Requirements

- WordPress 5.0 or higher
- PHP 7.0 or higher
- Active Supabase account (free tier works)
- Valid sitemap.xml file
- HTTPS recommended for Supabase

## API & Customization

### Available Filters (Future)

```php
// Customize auto-generated keywords
add_filter('seoinux_auto_keywords', function($keywords, $title) {
    // Modify keywords
    return $keywords;
}, 10, 2);

// Modify suggestion results
add_filter('seoinux_suggestions', function($suggestions) {
    // Filter or sort suggestions
    return $suggestions;
});
```

### Available Actions (Future)

```php
// After sitemap refresh
add_action('seoinux_after_refresh', function($inserted, $updated) {
    // Custom logic
});

// After keyword save
add_action('seoinux_after_save_keywords', function($url, $keywords) {
    // Custom logic
});
```

## Support

For issues, questions, or feature requests:
- Check the documentation
- Review troubleshooting section
- Check WordPress debug log
- Verify Supabase connection

## Changelog

### Version 2.0.0
- **NEW**: Automatic keyword generation from titles
- **NEW**: Supabase cloud database integration
- **NEW**: Regenerate keywords functionality
- **NEW**: Combined keyword system (auto + custom)
- **IMPROVED**: Faster keyword matching
- **IMPROVED**: Scalable cloud storage
- **UPDATED**: New branding and UI
- **REMOVED**: Local WordPress database tables

### Version 1.0.0
- Initial release
- Basic sitemap parsing
- Manual keyword entry
- WordPress database storage

## License

GPL v2 or later

## Credits

Developed by SEOINUX | Powered by Supabase
