/**
 * Admin JavaScript for SEOINUX SEO Internal Link Creator
 */

(function($) {
    'use strict';

    $(document).ready(function() {

        // Refresh sitemap
        $('#seoinux-refresh-sitemap').on('click', function() {
            const button = $(this);
            const messageDiv = $('#seoinux-refresh-message');

            button.prop('disabled', true);
            button.html('<span class="dashicons dashicons-update rotating"></span> Refreshing & Generating Keywords...');
            messageDiv.html('');

            $.ajax({
                url: seoinuxAjax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'seoinux_refresh_sitemap',
                    nonce: seoinuxAjax.nonce
                },
                success: function(response) {
                    if (response.success) {
                        messageDiv.html('<div class="notice notice-success"><p>' + response.data.message + '</p></div>');
                        // Reload page after 2 seconds to show updated stats
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        messageDiv.html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>');
                    }
                },
                error: function() {
                    messageDiv.html('<div class="notice notice-error"><p>Failed to refresh sitemap. Please try again.</p></div>');
                },
                complete: function() {
                    button.prop('disabled', false);
                    button.html('<span class="dashicons dashicons-update"></span> Refresh Sitemap & Auto-Generate Keywords');
                }
            });
        });

        // Regenerate keywords for a single URL
        $('.seoinux-regenerate-keywords').on('click', function() {
            const button = $(this);
            const url = button.data('url');
            const row = button.closest('tr');
            const autoKeywordsDiv = row.find('.seoinux-auto-keywords');

            button.prop('disabled', true);
            button.text('Generating...');

            $.ajax({
                url: seoinuxAjax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'seoinux_regenerate_keywords',
                    nonce: seoinuxAjax.nonce,
                    url: url
                },
                success: function(response) {
                    if (response.success) {
                        autoKeywordsDiv.html('<small>' + response.data.keywords + '</small>');
                        button.text('Regenerated!');
                        setTimeout(function() {
                            button.text('Regenerate');
                        }, 2000);
                    } else {
                        alert('Error: ' + response.data.message);
                    }
                },
                error: function() {
                    alert('Failed to regenerate keywords. Please try again.');
                },
                complete: function() {
                    button.prop('disabled', false);
                }
            });
        });

        // Save individual keywords
        $('.seoinux-save-keywords').on('click', function() {
            const button = $(this);
            const url = button.data('url');
            const row = button.closest('tr');
            const textarea = row.find('.seoinux-keywords-input');
            const keywords = textarea.val();

            button.prop('disabled', true);
            button.text('Saving...');

            $.ajax({
                url: seoinuxAjax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'seoinux_save_keywords',
                    nonce: seoinuxAjax.nonce,
                    url: url,
                    keywords: keywords
                },
                success: function(response) {
                    if (response.success) {
                        button.text('Saved!');
                        textarea.css('border-color', '#46b450');
                        setTimeout(function() {
                            button.text('Save');
                            textarea.css('border-color', '');
                        }, 2000);
                    } else {
                        alert('Error: ' + response.data.message);
                    }
                },
                error: function() {
                    alert('Failed to save keywords. Please try again.');
                },
                complete: function() {
                    button.prop('disabled', false);
                }
            });
        });

        // Save all keywords
        $('#seoinux-save-all-keywords').on('click', function() {
            const button = $(this);
            const rows = $('.seoinux-keywords-table tbody tr');
            let savedCount = 0;
            let totalRows = rows.length;

            button.prop('disabled', true);
            button.text('Saving...');

            rows.each(function(index) {
                const row = $(this);
                const url = row.data('url');
                const keywords = row.find('.seoinux-keywords-input').val();

                $.ajax({
                    url: seoinuxAjax.ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'seoinux_save_keywords',
                        nonce: seoinuxAjax.nonce,
                        url: url,
                        keywords: keywords
                    },
                    success: function(response) {
                        savedCount++;
                        if (savedCount === totalRows) {
                            button.text('All Saved!');
                            setTimeout(function() {
                                button.text('Save All Custom Keywords');
                                button.prop('disabled', false);
                            }, 2000);
                        }
                    }
                });
            });
        });

        // Copy link functionality for meta box
        $(document).on('click', '.seoinux-copy-link', function() {
            const button = $(this);
            const url = button.data('url');
            const keyword = button.data('keyword');
            const linkHtml = '<a href="' + url + '">' + keyword + '</a>';

            // Copy to clipboard
            const tempInput = $('<textarea>');
            $('body').append(tempInput);
            tempInput.val(linkHtml).select();
            document.execCommand('copy');
            tempInput.remove();

            // Show feedback
            const originalText = button.text();
            button.text('Copied!');
            setTimeout(function() {
                button.text(originalText);
            }, 2000);
        });

        // Add rotating animation for refresh icon
        const style = document.createElement('style');
        style.textContent = `
            @keyframes rotate {
                from { transform: rotate(0deg); }
                to { transform: rotate(360deg); }
            }
            .rotating {
                animation: rotate 1s linear infinite;
                display: inline-block;
            }
        `;
        document.head.appendChild(style);
    });

})(jQuery);
