<?php
/**
 * Uninstall script for SEOINUX SEO Internal Link Creator
 * Runs when the plugin is deleted via WordPress admin
 */

// Exit if accessed directly or not in uninstall process
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('seoinux_sitemap_url');
delete_option('seoinux_max_suggestions');
delete_option('seoinux_auto_refresh');
delete_option('seoinux_auto_generate_keywords');

// Remove scheduled cron events
wp_clear_scheduled_hook('seoinux_refresh_sitemap_cron');

// Drop database tables
global $wpdb;
$table_name = $wpdb->prefix . 'seoinux_links';
$wpdb->query("DROP TABLE IF EXISTS {$table_name}");

// Clear any cached data
wp_cache_flush();
