# SEOINUX Cache Pro - Installation Instructions

## Installation Methods

### Method 1: WordPress Admin Panel (Recommended)

1. **Create Plugin ZIP File:**
   ```bash
   cd /tmp/cc-agent/63956740/project
   cd wordpress-plugin
   zip -r seoinux-cache-pro.zip .
   ```

2. **Upload to WordPress:**
   - Log in to your WordPress admin panel
   - Navigate to **Plugins → Add New**
   - Click **Upload Plugin**
   - Choose the `seoinux-cache-pro.zip` file
   - Click **Install Now**
   - Once installed, click **Activate Plugin**

### Method 2: FTP/SFTP Upload

1. **Copy Plugin Folder:**
   - Upload the entire `wordpress-plugin` folder to your WordPress installation
   - Place it in: `/wp-content/plugins/seoinux-cache-pro/`

2. **Activate Plugin:**
   - Log in to WordPress admin panel
   - Navigate to **Plugins → Installed Plugins**
   - Find "SEOINUX Cache Pro"
   - Click **Activate**

### Method 3: Command Line (SSH)

```bash
# Navigate to WordPress plugins directory
cd /path/to/wordpress/wp-content/plugins/

# Copy plugin folder
cp -r /tmp/cc-agent/63956740/project/wordpress-plugin seoinux-cache-pro

# Set correct permissions
chown -R www-data:www-data seoinux-cache-pro
chmod -R 755 seoinux-cache-pro

# Activate via WP-CLI (if available)
wp plugin activate seoinux-cache-pro
```

## Post-Installation Setup

1. **Access Plugin Dashboard:**
   - In WordPress admin, look for **SEOINUX Cache** in the left sidebar
   - Click to open the plugin dashboard

2. **Configure Settings:**
   - **Cache Settings:** Enable page cache, browser cache, and GZIP compression
   - **Image Optimisation:** Enable lazy loading and WebP conversion
   - **Advanced Options:** Configure minification and other optimisations as needed

3. **Test Your Site:**
   - Browse your website to ensure everything works correctly
   - Use the PageSpeed Tools tab to test performance
   - Click the Google PageSpeed Insights or GTmetrix buttons

4. **Monitor Performance:**
   - Check the dashboard for real-time statistics
   - Monitor cache hit rates and page load times
   - Review image optimisation stats

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Apache or Nginx web server
- GD or Imagick PHP extension (for image optimisation)
- mod_rewrite enabled (for .htaccess rules)

## File Permissions

Ensure these directories are writable:
- `/wp-content/cache/` (will be created by plugin)
- `/.htaccess` (for browser caching rules)

## Troubleshooting

### Plugin Won't Activate
- Check PHP version (must be 7.4+)
- Verify all plugin files uploaded correctly
- Check error logs: `wp-content/debug.log`

### Cache Not Working
- Verify page cache is enabled in settings
- Check cache directory permissions: `/wp-content/cache/seoinux-cache-pro/`
- Clear cache using the "Clear All Cache" button

### Images Not Optimising
- Ensure GD or Imagick extension is installed
- Check PHP memory limit (recommended: 256MB+)
- Test with a few images first

### 500 Internal Server Error
- Check .htaccess file for syntax errors
- Temporarily disable GZIP compression
- Contact your hosting provider

### White Screen After Activation
- Disable the plugin via FTP (rename plugin folder)
- Check PHP error logs
- Ensure PHP memory limit is adequate

## Support

For support and documentation:
- Website: https://seoinux.com
- Documentation: https://seoinux.com/docs/cache-pro
- Support: https://seoinux.com/support
- Free SEO Tools: https://tools.seoinux.com

## Uninstallation

To completely remove the plugin:

1. **Deactivate Plugin:**
   - Go to **Plugins → Installed Plugins**
   - Click **Deactivate** under SEOINUX Cache Pro

2. **Delete Plugin:**
   - Click **Delete** under the deactivated plugin
   - Confirm deletion

3. **Clean Up (Optional):**
   - The uninstall script automatically removes:
     - All plugin options from database
     - Cache directory and files
     - .htaccess modifications

## Features Overview

### Cache Management
- ✅ Page cache with configurable duration
- ✅ Browser cache for static resources
- ✅ Object cache support
- ✅ GZIP compression
- ✅ One-click cache clearing

### Image Optimisation
- ✅ Lazy loading
- ✅ WebP conversion
- ✅ Auto-resize large images
- ✅ Adjustable compression levels
- ✅ Bulk optimisation

### PageSpeed Tools
- ✅ Google PageSpeed Insights integration
- ✅ GTmetrix integration
- ✅ Core Web Vitals monitoring
- ✅ Performance score tracking

### Advanced Features
- ✅ HTML/CSS/JS minification
- ✅ File combination
- ✅ Deferred JavaScript loading
- ✅ CDN configuration
- ✅ Database optimisation
- ✅ DNS prefetch

## Security

SEOINUX Cache Pro:
- ✅ Does not collect personal data
- ✅ All processing happens locally
- ✅ No external API calls (except user-initiated PageSpeed tests)
- ✅ Secure AJAX with WordPress nonces
- ✅ Capability checks for all admin functions

## License

GPL v2 or later
https://www.gnu.org/licenses/gpl-2.0.html
