<?php
/**
 * Uninstall SEOINUX Cache Pro
 *
 * Fires when the plugin is uninstalled
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
$options = array(
    'seoinux_page_cache',
    'seoinux_browser_cache',
    'seoinux_object_cache',
    'seoinux_gzip_compression',
    'seoinux_cache_duration',
    'seoinux_lazy_load',
    'seoinux_webp_conversion',
    'seoinux_auto_resize',
    'seoinux_compression_level',
    'seoinux_max_width',
    'seoinux_minify_html',
    'seoinux_minify_css',
    'seoinux_minify_js',
    'seoinux_combine_css',
    'seoinux_combine_js',
    'seoinux_defer_js',
    'seoinux_lazy_load_videos',
    'seoinux_preload_fonts',
    'seoinux_cdn_enabled',
    'seoinux_cdn_url',
    'seoinux_database_optimization',
    'seoinux_remove_query_strings',
    'seoinux_dns_prefetch',
    'seoinux_cache_hits',
    'seoinux_cache_misses',
    'seoinux_load_times',
    'seoinux_bandwidth_saved',
    'seoinux_images_optimized',
);

foreach ($options as $option) {
    delete_option($option);
}

// Delete cache directory
$cache_dir = WP_CONTENT_DIR . '/cache/seoinux-cache-pro';
if (file_exists($cache_dir)) {
    $files = glob($cache_dir . '/*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file);
        }
    }
    rmdir($cache_dir);
}

// Clean up .htaccess
$htaccess_file = ABSPATH . '.htaccess';
if (file_exists($htaccess_file) && is_writable($htaccess_file)) {
    $htaccess_content = file_get_contents($htaccess_file);
    $htaccess_content = preg_replace('/#\s*BEGIN SEOINUX Cache.*?#\s*END SEOINUX Cache/s', '', $htaccess_content);
    file_put_contents($htaccess_file, $htaccess_content);
}
